local assets =
{
	Asset("ANIM", "anim/ast0.zip"),
    Asset("ATLAS", "images/inventoryimages/ast_sr_foodworktable.xml"),
	Asset("ATLAS", "images/inventoryimages/geneshujuku.xml"),
}
STRINGS.NAMES.AST_SR_FOODWORKTABLE = "指令卡-SR-料理台"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.AST_SR_FOODWORKTABLE= "消耗木材12，石材6，金子6获取料理台"
STRINGS.NAMES.GENESHUJUKU = "基因数据库Ⅰ"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.GENESHUJUKU = "—————————————————————\n│花瓣＝再生基因│松果＝自适应基因　　　│\n│食人花种子＝骨骼＋敏捷＋免疫＋叶绿素　｜\n│胡萝卜＝螺旋基因＋抵抗基＋能量基因　　│\n│浆果＝水分基因＋叶绿素基因　　　　　　│\n│红蘑菇＝发光＋毒性＋自适应基因　　　　│\n│蓝蘑菇＝发光＋再生＋自适应基因　　　　│\n│绿蘑菇＝发光＋虚空＋自适应基因　　　　│\n—————————————————————"
local function buildgene(lei)
local function fn()
    local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.entity:AddSoundEmitter()
    inst.entity:AddNetwork()

    MakeInventoryPhysics(inst)

    inst.AnimState:SetBank("ast0")
    inst.AnimState:SetBuild("ast0")
    inst.AnimState:PlayAnimation("idle")

    inst.entity:SetPristine()

    if not TheWorld.ismastersim then
        return inst
    end
	inst:AddTag("molebait")
    inst:AddComponent("inspectable")
    inst:AddComponent("inventoryitem")
	inst:AddComponent("tradable")
    inst.components.inventoryitem.imagename = lei
    inst.components.inventoryitem.atlasname = "images/inventoryimages/"..lei..".xml"
    inst:AddComponent("selfstacker")

    MakeHauntableLaunchAndSmash(inst)

    return inst
end
return Prefab(lei, fn, assets)
end
return buildgene("ast_sr_foodworktable"),
buildgene("geneshujuku",true)